% This procedure creates table 21
% It uses the estimation results produced in GMM_main
clear

load ../../'Estimation Results'/Benchmark_Model.mat parameters

benchm_par = parameters;

load ../../'Estimation Results'/Model_w_inv_shocks.mat
disp(' ')
disp('Table 21: Estimated parameters: investment cost shocks')
disp(' ')
disp( 'Parameter        Estimate    (s.e.)   Benchm. Estimate')
disp(['epsilon            ' num2str(parameters(13), '%.2f') '      (' num2str(std_error(1), '%.3f') ')       ' num2str(benchm_par(13), '%.2f')])
disp(['rho_a1             ' num2str(parameters(14), '%.2f') '      (' num2str(std_error(2), '%.2f') ')        ' num2str(benchm_par(14), '%.2f')])
disp(['rho_a2            ' num2str(parameters(15), '%.2f') '      (' num2str(std_error(3), '%.2f') ')       ' num2str(benchm_par(15), '%.2f')])
disp(['sd_a               ' num2str(parameters(22)^(0.5), '%.3f') '     (' num2str(0.5*std_error(10)/parameters(22)^(0.5), '%.3f') ')       ' num2str(benchm_par(17)^(0.5), '%.3f')]) % using Delta method
disp(['rho_zn1            ' num2str(parameters(16), '%.2f') '      (' num2str(std_error(4), '%.2f') ')        ' ])
disp(['rho_zn2           ' num2str(parameters(17), '%.2f') '      (' num2str(std_error(5), '%.2f') ')       ' ])
disp(['sd_zn              ' num2str(parameters(20)^(0.5), '%.3f') '     (' num2str(0.5*std_error(8)/parameters(20)^(0.5), '%.3f') ')       ' ]) % using Delta method
disp(['rho_zo1            ' num2str(parameters(18), '%.2f') '      (' num2str(std_error(6), '%.2f') ')        ' ])
disp(['rho_zo2           ' num2str(parameters(19), '%.2f') '      (' num2str(std_error(7), '%.2f') ')       ' ])
disp(['sd_zo              ' num2str(parameters(21)^(0.5), '%.3f') '     (' num2str(0.5*std_error(9)/parameters(21)^(0.5), '%.3f') ')       ' ]) % using Delta method

